# Quantificate Brand Assets

This package contains the official Quantificate branding resources.  
Use these assets consistently across all web, print, and digital channels to maintain a unified identity.

---

## 📁 logo/
- **logo_light.svg / .png** → For use on white or light backgrounds.  
- **logo_dark.svg / .png** → For use on dark backgrounds.  
- **logo_light_on_transparent.svg / .png** → For overlay on photos, gradients, or colored backgrounds.  
- Resolutions provided: **512px, 1024px, 2048px** (use higher resolution for print or large screens).

## 📁 avatars/
- Square icon-only “Data Wings” mark.  
- **avatar_light** → For light backgrounds.  
- **avatar_dark** → For dark backgrounds.  
- **avatar_transparent** → White thorax, designed for overlays.  
- Provided in **128px, 256px, 512px** (use 512px for high-res, 128px for profile pics).

## 📁 favicon/
- **favicon.ico** → Multi-size (16, 32, 48, 64px) for browsers.  
- **favicon_64.png** → PNG fallback for CMS or apps that don’t accept .ico.

## 📁 brand-kit/
- **Quantificate_Brand_Kit_v4.pdf** → Complete brand guide including logo usage, colors, typography, and rules.

---

## ✅ Usage Guidelines
- Maintain clear space around the logo.  
- Do not stretch, distort, recolor, or add effects.  
- Use the **dark variant** on #0F172A (ink) or similarly dark surfaces.  
- Use the **light-on-transparent** variant on busy backgrounds (photos, gradients).  
- Use **square avatars** for favicons, social media profiles, or app icons.  
- Ensure accessibility: maintain strong color contrast (WCAG AA compliance).  

---

© 2025 Quantificate. All rights reserved.
